<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Domains
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 31 January 2019
 */
class Parcours extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('sequence_model');
        $this->load->model('chapitres_model');
        $this->load->model('matieres_model');
        $this->load->model('modules_model');
        $this->load->model('parcours_model');
        
        $this->load->model('sessions_model');
        $this->load->model('groupes_model');
        $this->load->model('formations_model');
        $this->load->model('utilities_model');
        $this->load->model('membres_model');
        $this->load->model('domaines_model');
        $this->form_validation->set_error_delimiters($this->config->item('error_prefix'), $this->config->item('error_suffix'));
        $this->isLoggedIn();   
        
    }
    
    /**
     * This function used to load the first screen of the user
     */
    /*public function index($idmat)
    {
        $this->global['pageTitle'] = 'E-learning : Parcours management';
        
        $ret = '';

        $action = array() ;

        $par = $this->parcours_model->readByDomaine($idd=-1);
        $id_ref = -1 ; 
        
        for($i=0;$i<$par['cnt'];$i++)  {
 
            //$link = LienClick(array('url'=>PAGE.'&action=liste&id_domaine='.$idd.'&id_matiere='.$par[$i]['matiere_id'], 'val'=>$name));
            //$this->tree->addMatiere($link,true);
 
            //$link = LienNormal(array('url'=>PAGE.'&action=liste&id_domaine='.$idd.'&id_matiere='.$par[$i]['matiere_id'], 'val'=>$name));
            //$this->tree->addMatiere($link);



            /*$ret .= '<li><span class="domaineName">'.$par[$i]['name'].'</span>

                <input type="hidden" name="domainsId" class="domainsId" value="'.$par[$i]['id'].'">
                <input type="hidden" name="domainstext" class="domainstext" value="'.$par[$i]['name'].'">

                <a title="Delete domains" href="#" class="deleteDomaine">&nbsp;&nbsp;<span class="glyphicon glyphicon-trash"></span></a><a href="#" class="editDomaine"  data-toggle="modal" data-target="#exampleModal" title="Edit domains">&nbsp;&nbsp;<span class="glyphicon glyphicon-edit"></span></a><a href="#" class="addmaterial"  title="Add new material">&nbsp;&nbsp;<span class="glyphicon glyphicon-plus"></span></a><ul class="materialmenu">';

            $mat = $this->matieres_model->readAll($dom[$i]['id']);
            for ($j=0;$j<$mat['cnt'];$j++) {

                $ret .= '<li class="material">
                <input type="hidden" name="materialsId" class="materialsId" value="'.$mat[$j]['id'].'">
                <input type="hidden" name="materialstext" class="materialstext" value="'.$mat[$j]['name'].'">

                <a title="Delete material" href="#" class="deleteMaterial">&nbsp;&nbsp;<span class="glyphicon glyphicon-trash"></span></a><a href="#" class="editMaterial"  title="Edit material">&nbsp;&nbsp;<span class="glyphicon glyphicon-edit"></span></a><a href="#" class="moveMaterial"  title="Move material in other domains">&nbsp;&nbsp;<span class="glyphicon glyphicon-move"></span></a>&nbsp;&nbsp;<span class="materialName">'.$mat[$j]['name'].'</span></li>';
            }

            
            $ret .= '</ul></li>';*/
       /* }

        $this->global['content'] = $ret;

        $this->loadViews("admin/parcours/index", $this->global,NULL, NULL );
    }*/

    public function index(){
        $this->global['pageTitle'] = 'E-learning : Parcours management';        
        $key = $this->input->post('recherche');
        $action = array() ;
        $ret = $this->parcours_model->rechercher($key);
        for($i=0;$i<$ret['cnt'];$i++)  {
          $result = $this->utilities_model->afficheLienRechercher($ret[$i],LOC);
          $details = '' ;
            if ( DETAILS == 1 ) {
              $details = afficheDetailParcours($ret[$i]['id'],LOC);
              $details.= BR();
            }
            $table2->addrow(array($result.BR().$details));
        }
        $table->addRow(array($table2->toHTML()));
        $res.=  $table->toHTML();
        return($res);

        $this->global['content'] = $ret;
        $this->loadViews("admin/parcours/index", $this->global,NULL, NULL );
    }

    public function afficheDetailParcours($idp,$loc,$position=false){
        $table = new HTML_Table_Admin(array(10,70,20), 90, array("",$ad_titre['gest_parcours'], $ad_form['action']));
        $detail = $ClsParcours->readParcours($idp,$loc);
        for($j=0;$j<$detail['cnt'];$j++)  {
            $ligne = array();
            $cmd_ordre = '';
            $ordre  = $detail[$j]['ordre'] ;
            if ( $position ) {
                $up     = PAGE.'&action=up&id='.$idp.'&ordre='.$ordre;
                $up     = LienNormal(array('url'=>$up, 'val'=>IMG_UP));
                $down   = PAGE.'&action=down&id='.$idp.'&ordre='.$ordre;
                $down   = LienNormal(array('url'=>$down, 'val'=>IMG_DOWN));

                if ( $j == 0 ) {
                    if ( $detail['cnt']  <> 1 ) {
                        $cmd_ordre.= $down."\n";
                    }
                } elseif ( $j == ($detail['cnt']-1) ) {
                    $cmd_ordre.= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$up."\n";
                } else {
                    $cmd_ordre.= $down.$up."\n";
                }
            }
            $ligne[] = $cmd_ordre ;

            if ($detail[$j]['type'] == TYPE_SEQUENCE ) {
                $img = IMG_TYPE_SEQUENCE ;
                if ( GINSTALL==GANESHA_SITE || GINSTALL==GANESHA_STANDARD) {
                   $img = $detail[$j]['loc']==LOCAL?IMG_TYPE_SEQUENCE_LOCAL:IMG_TYPE_SEQUENCE;
                }
                $ligne[] = $img.' '.$ordre.' - '.CSS($ClsSequence->Title($detail[$j]['item_id'],$detail[$j]['loc']));

                $detail[$j]['titre'] = $ClsSequence->Title($detail[$j]['item_id'],$detail[$j]['loc']);
                $detail[$j]['id'] = $detail[$j]['item_id'];
                $seq = lienTitreSuppModifView($detail[$j],$detail[$j]['loc'],true);
                //debug($seq);
                $delitem = PAGE.'&action=deletesequence&id='.ID.'&id_item='.$detail[$j]['item_id'].'&ordre='.$ordre.'&cur_loc='.$detail[$j]['loc'];
                $ligne[] = LienNormal(array('url'=>'#', 'action'=>'onclick="DeleteItem(\''.$delitem.'\');"', 'val'=>IMG_DEL))." ".$seq['lview'];
            } 
            else {
                // TYPE_MODULE
                $img = IMG_TYPE_MODULE ;
                if ( GINSTALL==GANESHA_SITE || GINSTALL==GANESHA_STANDARD) {
                   $img = $detail[$j]['loc']==LOCAL?IMG_TYPE_MODULE_LOCAL:IMG_TYPE_MODULE;
                }
                $ligne[] = $img.' '.$ordre.' - '.CSS($ClsModule->Title($detail[$j]['item_id'],$detail[$j]['loc']));
                $delitem = PAGE.'&action=deletemodule&id='.ID.'&id_item='.$detail[$j]['item_id'].'&ordre='.$ordre.'&cur_loc='.$detail[$j]['loc'];
                $ligne[] = LienNormal(array('url'=>'#', 'action'=>'onclick="DeleteItem(\''.$delitem.'\');"', 'val'=>IMG_DEL));
            }
            $table->addRow($ligne);
        }
        return ($table->toHTML());
    }

    public function deletematerial(){
        $id = $this->input->post('id');
        $this->matieres_model->del($id) ;
        $this->sequence_model->delMatiere($id);
        $this->modules_model->delMatiere($id);
        $this->parcours_model->delMatiere($id);
    }

    public function delete(){
        $id = $this->input->post('idDomains');
        $this->domaines_model->del($id) ;
        $this->matieres_model->delAll($id) ;
        $this->sequence_model->delDomaine($id);
        $this->modules_model->delDomaine($id);
        $this->parcours_model->delDomaine($id);
        return true;
    }
  
    public function add(){
        $name   = $this->input->post('domain_name');
        $id     = $this->domaines_model->add($name);
        redirect("/managedomains","refresh");
    }

    public function edit(){
        
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->domaines_model->update($id, $name);
        echo "###".$id."###";
    }

    public function editmatiere(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->matieres_model->update($id, $name);
        echo "###".$id."###";
    }

    public function addmaterial(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $id     = $this->matieres_model->add($name, $id);
        echo "###".$id."###";
    }

    public function showall(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $dom            = $this->domaines_model->read(-1,LOC);
        $ret            = "";
        //$cursor         = "";
        for($i=0;$i<$dom['cnt'];$i++)  {
            /*$mat = $this->matieres_model->readAll($dom[$i]['id']);
            for ($j=0;$j<$mat['cnt'];$j++) {
                if ($mat[$j]['id']==$idMaterial) {
                    # code...
                }
            }*/
            if ( in_array($dom[$i]['id'],$idDomains) ) {
                $cursor         = "not-allowed";
            } 
            else {
                $cursor         = "pointer";
            }
            $ret .= '<p><a class="movematerials" onclick="movematerial(this);">';
            $ret .= '<input type="hidden" class="materialid" value="'.$idMaterial.'">';
            $ret .= '<input type="hidden" class="domainsid" value="'.$dom[$i]['id'].'">';
            $ret .= '<span class="glyphicon glyphicon-plus" style="cursor:'.$cursor.';"></span>&nbsp;&nbsp;'.$dom[$i]['name'].'</a></p>';
        }
        echo "###".$ret."###";
    }

    public function movematerial(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $this->matieres_model->move($idMaterial,$idDomains,LOC);
        $this->sequence_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->modules_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->parcours_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);

    }

}

?>